﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/erpt/server/erpt_ServerTypes.h>

namespace nn   {
namespace erpt {
namespace srv  {

class IManager :
    public nn::util::IntrusiveListBaseNode<IManager>,
    public nn::sf::ISharedObject
{
private:
    static nn::util::IntrusiveList<IManager, nn::util::IntrusiveListBaseNodeTraits<IManager>> m_ManagerList;

    nn::os::SystemEvent m_SystemEvent;

    void NotifyOne()
    NN_NOEXCEPT;

public:
    static nn::Result NotifyAll()
    NN_NOEXCEPT;

    nn::Result GetReportList(nn::sf::OutBuffer listBufferOut, ReportType filterType)
    NN_NOEXCEPT;

    nn::Result GetEvent(nn::sf::Out<nn::sf::NativeHandle> eventHandleOut)
    NN_NOEXCEPT;

    nn::Result CleanupReports()
    NN_NOEXCEPT;

    nn::Result DeleteReport(ReportId reportId)
    NN_NOEXCEPT;

    nn::Result GetStorageUsageStatistics(nn::sf::Out<nn::erpt::StorageUsageStatistics> outUsage)
    NN_NOEXCEPT;

    IManager()
    NN_NOEXCEPT;

    ~IManager()
    NN_NOEXCEPT;
};

}}}
