﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/erpt/erpt_SystemApi.h>
#include "erpt_Session.h"

namespace nn { namespace erpt {

nn::Result SetInitialLaunchSettingsCompletionTime(const time::SteadyClockTimePoint& timePoint) NN_NOEXCEPT
{
    nn::sf::SharedPointer<sf::IContext> pContextImpl;
    NN_RESULT_DO(GetContextObject(&pContextImpl));

    NN_RESULT_DO(pContextImpl->SetInitialLaunchSettingsCompletionTime(timePoint));
    NN_RESULT_SUCCESS;
}

nn::Result ClearInitialLaunchSettingsCompletionTime() NN_NOEXCEPT
{
    nn::sf::SharedPointer<sf::IContext> pContextImpl;
    NN_RESULT_DO(GetContextObject(&pContextImpl));

    NN_RESULT_DO(pContextImpl->ClearInitialLaunchSettingsCompletionTime());
    NN_RESULT_SUCCESS;
}

nn::Result UpdatePowerOnTime() NN_NOEXCEPT
{
    nn::sf::SharedPointer<sf::IContext> pContextImpl;
    NN_RESULT_DO(GetContextObject(&pContextImpl));

    NN_RESULT_DO(pContextImpl->UpdatePowerOnTime());
    NN_RESULT_SUCCESS;
}

nn::Result UpdateAwakeTime() NN_NOEXCEPT
{
    nn::sf::SharedPointer<sf::IContext> pContextImpl;
    NN_RESULT_DO(GetContextObject(&pContextImpl));

    NN_RESULT_DO(pContextImpl->UpdateAwakeTime());
    NN_RESULT_SUCCESS;
}

}}
