﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/system/ec_TicketApi.h>
#include <nn/ec/system/ec_TicketSystemApi.h>
#include <nn/ec/ec_Result.h>
#include <nn/nifm/nifm_ApiClientManagement.h>

#include "ec_ResultUtil.h"
#include "ec_ShopServiceObject.h"

namespace nn { namespace ec { namespace system {
namespace {
    Result RequestSyncTicketImpl(AsyncProgressResult* outValue) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncProgressResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestSyncTicket(&nativeHandle, &sp));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }
}

    Result RequestDownloadTicket(AsyncResult* outValue, const es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestDownloadTicket(&nativeHandle, &sp, rightsId));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestDownloadTicketForPrepurchasedContents(AsyncTicketDownloadStatusForPrepurchasedContents* outValue, const es::RightsIdIncludingKeyId& rightsId) NN_NOEXCEPT
    {
        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncValue> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestDownloadTicketForPrepurchasedContents(&nativeHandle, &sp, rightsId));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

    Result RequestSyncTicket(AsyncProgressResult* outValue) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());
        NN_RESULT_DO(RequestSyncTicketImpl(outValue));
        NN_RESULT_SUCCESS;
    }

    Result RequestSyncTicketForSystem(AsyncProgressResult* outValue) NN_NOEXCEPT
    {
        return RequestSyncTicketImpl(outValue);
    }
}}}
