﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/system/ec_NotificationApi.h>
#include <nn/ec/ec_Result.h>
#include <nn/nifm/nifm_ApiClientManagement.h>

#include "ec_ResultUtil.h"
#include "ec_ShopServiceObject.h"

namespace nn { namespace ec { namespace system {

    Result RequestRegisterNotificationToken(AsyncResult* outValue, const npns::NotificationToken& notificationToken) NN_NOEXCEPT
    {
        NN_RESULT_THROW_UNLESS(nifm::IsAnyInternetRequestAccepted(nifm::GetClientId()), ResultInternetRequestNotAccepted());

        sf::NativeHandle nativeHandle;
        sf::SharedPointer<nim::detail::IAsyncResult> sp;
        NN_EC_RESULT_DO(GetShopServiceObject().RequestRegisterNotificationToken(&nativeHandle, &sp, notificationToken));
        outValue->Initialize(sp, nativeHandle);
        nativeHandle.Detach();

        NN_RESULT_SUCCESS;
    }

}}}
