﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/ec_ShopApi.h>

#include <nn/nn_SdkAssert.h>
#include <nn/account/account_ApiForApplications.h>
#include <nn/ec/detail/ec_ShopApiInternal.h>
#include <nn/ec/detail/ec_Utils.h>

namespace nn { namespace ec {

void ShowShopApplicationInformation(nn::ApplicationId applicationId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationId != nn::ApplicationId::GetInvalidId(),
        "'applicationId' must be valid");

    detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Mini, applicationId, nn::account::InvalidUid, SourceId_Default, nullptr);
}

void ShowShopApplicationInformation(nn::ApplicationId applicationId, const nn::account::UserHandle& selectedUser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationId != nn::ApplicationId::GetInvalidId(),
        "'applicationId' must be valid");

    nn::account::Uid uid;
    auto result = nn::account::GetUserId(&uid, selectedUser);
    if (result.IsFailure())
    {
        uid = nn::account::InvalidUid;
    }
    detail::ShowShopApplicationInformationImpl(detail::LaunchMode_Mini, applicationId, uid, SourceId_Default, nullptr);
}

void ShowShopAddOnContentList(nn::ApplicationId applicationIdParent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    detail::ShowShopAddOnContentListImpl(detail::LaunchMode_Mini, applicationIdParent, nn::account::InvalidUid, SourceId_Default);
}

void ShowShopAddOnContentList(nn::ApplicationId applicationIdParent, const nn::account::UserHandle& selectedUser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    nn::account::Uid uid;
    auto result = nn::account::GetUserId(&uid, selectedUser);
    if (result.IsFailure())
    {
        uid = nn::account::InvalidUid;
    }
    detail::ShowShopAddOnContentListImpl(detail::LaunchMode_Mini, applicationIdParent, uid, SourceId_Default);
}

void ShowShopSubscriptionList(nn::ApplicationId applicationIdParent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    detail::ShowShopSubscriptionListImpl(detail::LaunchMode_Mini, applicationIdParent, nn::account::InvalidUid, SourceId_Default);
}

void ShowShopSubscriptionList(nn::ApplicationId applicationIdParent, const nn::account::UserHandle& selectedUser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    nn::account::Uid uid;
    auto result = nn::account::GetUserId(&uid, selectedUser);
    if (result.IsFailure())
    {
        uid = nn::account::InvalidUid;
    }
    detail::ShowShopSubscriptionListImpl(detail::LaunchMode_Mini, applicationIdParent, uid, SourceId_Default);
}

void ShowShopSubscriptionList(nn::ApplicationId applicationIdParent, const CourseId& courseId) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    CourseId copyCourseId = courseId;
    NN_SDK_REQUIRES(detail::IsStringTerminated(copyCourseId.value, sizeof(copyCourseId.value)),
        "'courseId' must be terminated in '\0'");
    copyCourseId.value[MaxCourseIdStringLength] = '\0';

    detail::ShowShopSubscriptionListDetailImpl(detail::LaunchMode_Mini, applicationIdParent, copyCourseId, nn::account::InvalidUid, SourceId_Default);
}

void ShowShopSubscriptionList(nn::ApplicationId applicationIdParent, const CourseId& courseId, const nn::account::UserHandle& selectedUser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    CourseId copyCourseId = courseId;
    NN_SDK_REQUIRES(detail::IsStringTerminated(copyCourseId.value, sizeof(copyCourseId.value)),
        "'courseId' must be terminated in '\0'");
    copyCourseId.value[MaxCourseIdStringLength] = '\0';

    nn::account::Uid uid;
    auto result = nn::account::GetUserId(&uid, selectedUser);
    if (result.IsFailure())
    {
        uid = nn::account::InvalidUid;
    }
    detail::ShowShopSubscriptionListDetailImpl(detail::LaunchMode_Mini, applicationIdParent, copyCourseId, uid, SourceId_Default);
}

void ShowShopConsumableItemList(nn::ApplicationId applicationIdParent) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    detail::ShowShopConsumableItemListImpl(detail::LaunchMode_Mini, applicationIdParent, nn::account::InvalidUid, SourceId_Default);
}

void ShowShopConsumableItemList(nn::ApplicationId applicationIdParent, const nn::account::UserHandle& selectedUser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    nn::account::Uid uid;
    auto result = nn::account::GetUserId(&uid, selectedUser);
    if (result.IsFailure())
    {
        uid = nn::account::InvalidUid;
    }
    detail::ShowShopConsumableItemListImpl(detail::LaunchMode_Mini, applicationIdParent, uid, SourceId_Default);
}

void ShowShopConsumableItemDetail(nn::ApplicationId applicationIdParent, const ConsumableId& consumableId, NsUid nsuid) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    ConsumableId copyConsumableId = consumableId;
    NN_SDK_REQUIRES(detail::IsStringTerminated(copyConsumableId.value, sizeof(copyConsumableId.value)),
        "'consumableId' must be terminated in '\0'");
    copyConsumableId.value[MaxConsumableIdStringLength] = '\0';

    NN_SDK_REQUIRES(nsuid != nn::ec::NsUid::GetInvalidId(),
        "'nsuid' must be valid");

    detail::ShowShopConsumableItemDetailImpl(detail::LaunchMode_Mini, applicationIdParent, copyConsumableId, nsuid, nn::account::InvalidUid, SourceId_Default);
}

void ShowShopConsumableItemDetail(nn::ApplicationId applicationIdParent, const ConsumableId& consumableId, NsUid nsuid, const nn::account::UserHandle& selectedUser) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(applicationIdParent != nn::ApplicationId::GetInvalidId(),
        "'applicationIdParent' must be valid");

    ConsumableId copyConsumableId = consumableId;
    NN_SDK_REQUIRES(detail::IsStringTerminated(copyConsumableId.value, sizeof(copyConsumableId.value)),
        "'consumableId' must be terminated in '\0'");
    copyConsumableId.value[MaxConsumableIdStringLength] = '\0';

    NN_SDK_REQUIRES(nsuid != nn::ec::NsUid::GetInvalidId(),
        "'nsuid' must be valid");

    nn::account::Uid uid;
    auto result = nn::account::GetUserId(&uid, selectedUser);
    if (result.IsFailure())
    {
        uid = nn::account::InvalidUid;
    }

    detail::ShowShopConsumableItemDetailImpl(detail::LaunchMode_Mini, applicationIdParent, copyConsumableId, nsuid, uid, SourceId_Default);
}

}}
