﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/ec/detail/ec_ShowShopPageArg.h>

#include <nn/nn_SdkAssert.h>
#include <nn/web/common/web_CommonApi.h>
#include <nn/web/common/web_CommonArgData.h>
#include <nn/web/common/web_CommonTypes.h>

namespace nn { namespace ec { namespace detail {

//------------------------------------------------------------------------
ShowShopPageArg::ShowShopPageArg(const char* pRequestRelativeUrl) NN_NOEXCEPT
: m_Data()
{
    // 初期化
    nn::web::common::CommonArgData::InitializeData(m_Data, nn::web::common::ShimKind::Ec);

    // RelativeUrlを設定します。
    nn::web::common::CommonArgData::SetData(m_Data,
        nn::web::common::CommonArgData::ArgKind::RequestRelativeURL, RequestRelativeUrlMaxLength, pRequestRelativeUrl);

    // 左スティックモードを空間ナビへ変更する
    // refs; BROWSER1-550
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::LeftStickMode, nn::web::common::LeftStickMode::SpatialNavi);

    // ページ情報無効化
    // refs: BROWSER1-556
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::UsePageInfo, false);

    // Uidを無効値にする
    SetUid(nn::account::InvalidUid);

    // コンテンツ欠落を禁止する
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::IsContentsDropDisabled, true);

    // 再起動ダイアログを抑制する
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::SuppressRestartDialog, true);

    // 起動画面を白背景にする
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::BootDisplayKind, nn::web::common::BootDisplayKind::White);
}

//------------------------------------------------------------------------
void ShowShopPageArg::SetCallbackUrl(const char* pCallbackUrl) NN_NOEXCEPT
{
    nn::web::common::CommonArgData::SetData(m_Data,
        nn::web::common::CommonArgData::ArgKind::CallbackURL, CallbackUrlMaxLength, pCallbackUrl);
}

//------------------------------------------------------------------------
void ShowShopPageArg::SetCallbackableUrl(const char* pCallbackableUrl) NN_NOEXCEPT
{
    nn::web::common::CommonArgData::SetData(m_Data,
        nn::web::common::CommonArgData::ArgKind::CallbackableURL, CallbackableUrlMaxLength, pCallbackableUrl);
}

//------------------------------------------------------------------------
void ShowShopPageArg::SetUid(const nn::account::Uid& uid) NN_NOEXCEPT
{
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::Uid, uid);
}

//------------------------------------------------------------------------
void ShowShopPageArg::SetBackgroundKind(const ShopBackgroundKind backgroundKind) NN_NOEXCEPT
{
    nn::web::common::CommonArgData::SetData(m_Data, nn::web::common::CommonArgData::ArgKind::BackgroundKind, nn::web::common::BackgroundKind(backgroundKind));
}

//------------------------------------------------------------------------
uint8_t* ShowShopPageArg::GetRequestRelativeUrlBuffer() NN_NOEXCEPT
{
    auto p = nn::web::common::CommonArgData::GetDataPos(m_Data, nn::web::common::CommonArgData::ArgKind::RequestRelativeURL);
    NN_SDK_ASSERT_NOT_NULL(p);

    // バッファの先頭を返す
    return const_cast<uint8_t*>(nn::web::common::CommonArgData::GetDataBuffer(p));
}

//------------------------------------------------------------------------
void ShowShopPageArg::PushToInChannel(nn::applet::LibraryAppletHandle handle) const NN_NOEXCEPT
{
    nn::web::common::CommonApi::PushStorageToInChannel(handle, m_Data, DataSize);
}

//------------------------------------------------------------------------
ShopPageReturnValue::ShopPageReturnValue() NN_NOEXCEPT
: m_ExitReason()
, m_LastUrl()
, m_LastUrlSize()
{
}

//------------------------------------------------------------------------
ShopExitReason ShopPageReturnValue::GetShopExitReason() const NN_NOEXCEPT
{
    return static_cast<ShopExitReason>(m_ExitReason);
}

//------------------------------------------------------------------------
const char* ShopPageReturnValue::GetLastUrl() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == ShopExitReason_CallbackUrlReached);
    return m_LastUrl;
}

//------------------------------------------------------------------------
size_t ShopPageReturnValue::GetLastUrlSize() const NN_NOEXCEPT
{
    NN_SDK_REQUIRES(m_ExitReason == ShopExitReason_CallbackUrlReached);
    return size_t(m_LastUrlSize);
}

}}} // namespace nn::ec::detail
