﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/util/util_FormatString.h>
#include <nn/dns/parser/dns_ParserCommon.h>

//#define NN_DNSPARSER_LOG_LEVEL LOG_LEVEL_HEX
#define NN_DNSPARSER_LOG_MODULE_NAME "Common" // NOLINT(preprocessor/const)
#include "dns_ParserLog.h"
#include "dns_ParserMacros.h"

extern "C"
{
#include <nnc/dns/parser.h>
};

NN_DNSPARSER_STATIC_ASSERT(sizeof(struct nndnsparserMemoryBlock) == sizeof(nn::dns::parser::MemoryBlock));
NN_DNSPARSER_STATIC_ASSERT(alignof(struct nndnsparserMemoryBlock) == alignof(nn::dns::parser::MemoryBlock));
NN_DNSPARSER_STATIC_ASSERT(offsetof(struct nndnsparserMemoryBlock, pStart) == offsetof(nn::dns::parser::MemoryBlock, pStart));
NN_DNSPARSER_STATIC_ASSERT(offsetof(struct nndnsparserMemoryBlock, pEnd) == offsetof(nn::dns::parser::MemoryBlock, pEnd));

namespace nn { namespace dns { namespace parser {

bool MemoryBlockIsEqual(const MemoryBlock* pBlock1,
                        const MemoryBlock* pBlock2) NN_NOEXCEPT
{
    bool rc = false;

    NN_DNSPARSER_ERROR_IF(nullptr == pBlock1, bail);
    NN_DNSPARSER_ERROR_IF(nullptr == pBlock2, bail);

    rc = (pBlock1->pStart == pBlock2->pStart &&
          pBlock1->pEnd   == pBlock2->pEnd);

bail:
    return rc;
};

int CreateInaddrArpaString(char* pArpaBuffer,
                           size_t size,
                           uint32_t ipAddress) NN_NOEXCEPT
{
    const char* DnsInaddrArpaFormatString = "%d.%d.%d.%d.in-addr.arpa";
    int rc = -1;

    if (nullptr == pArpaBuffer)
    {
        goto bail;
    };

    rc = nn::util::SNPrintf(pArpaBuffer,
                            size,
                            DnsInaddrArpaFormatString,
                            (ipAddress & 0xFF000000) >> 24,
                            (ipAddress & 0x00FF0000) >> 16,
                            (ipAddress & 0x0000FF00) >>  8,
                            (ipAddress & 0x000000FF) );


bail:
    return rc;
};

const char* TrueOrFalseString(bool value) NN_NOEXCEPT
{
    return false == value ? "false" : "true";
};

}}}; //nn::dnsparser
