﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "dhcps_Common.h"
#include "dhcps_ProtocolStack.h"

/**
 * @file
 *
 * @brief This file provides global state functionality for the DHCP server.
 */
namespace nn { namespace dhcps { namespace detail {

/**
 * @brief Constants for each component of the DHCP server library.
 */
enum class GlobalState : uint8_t
{
    Thread             = 0, ///< 0
    Coordinator        = 1, ///< 1
    BpfManager         = 2, ///< 2
    ProtocolStack      = 3, ///< 3
    DhcpManager        = 4, ///< 4
    LeaseTableManager  = 5, ///< 5
    UdpSocketManager   = 6, ///< 6
    Max                = 7, ///< 7
};

/**
 * @brief Get a string representation for the provided component.
 *
 * @param[in] id The @ref GlobalState identifier.
 *
 * @return A string representation for the given GlobalState
 * identifier.
 */
const char* GlobalStateIdentifierToString(GlobalState id) NN_NOEXCEPT;

/**
 * @brief Sets the global state value for the provided component.
 *
 * @param[in] component The provided component.
 *
 * @param[in] value The value to set.
 */
void SetGlobalState(GlobalState component, uint8_t value) NN_NOEXCEPT;

/**
 * @brief Gets the global state value for the provided component.
 *
 * @param[in] component The provided component.
 *
 * @return The global state value for the given component.
 */
uint8_t GetGlobalState(GlobalState component) NN_NOEXCEPT;

}}}; // nn::dhcps::detail
