﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 *
 * @brief This file contains common header files.
 */

#include <nn/dhcps.h>
#include <nn/socket/socket_ApiPrivate.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_StringUtil.h>

#include <cstdlib>
#include <cstring>
#include <stdint.h>

#include <mutex>
#include <algorithm>

#include "dhcps_Types.h"
#include "dhcps_Utils.h"
#include "dhcps_Config.h"
#include "dhcps_Event.h"
#include "dhcps_GlobalState.h"


#define NN_DETAIL_DHCPS_STRINGIFY_CASE(type)            \
    case type:                                          \
    {                                                   \
        return #type;                                   \
    };
