﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#define NN_CPAD_DEBUG

#ifdef NN_CPAD_DEBUG
#define NN_CPAD_LOG(...) NN_SDK_LOG("nn::cpad::detail > " __VA_ARGS__);
#else
#define NN_CPAD_LOG(...)
#endif

namespace nn {
namespace cpad {
namespace detail {

/**
 * @brief アナログスティックの入力変化の有無を返す関数
 */
bool HasStickChange( const CpadStickState& pre, const CpadStickState& post, int threshold );

/**
 * @brief ディジタルボタンの入力変化の有無を返す関数
 */
bool HasButtonChange( const nn::util::BitPack32& pre, const nn::util::BitPack32& post );

/**
 * @brief   アナログスティック入力の八角形クランプを行います。
 *          デッドゾーン、最大値、入力定義域等はクラコンの仕様に依存します。
 *          Cafe の PADライブラリに準拠しています。
 */
void ClampStickState( CpadStickState* pOutState);

/**
 * @brief スティックの中央値を設定する関数
 */
void SetStickOrigin( CpadStickState* pInState, const CpadStickState& state );

} // detail
} // cpad
} // nn
