﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#if defined(NN_BUILD_CONFIG_HARDWARE_NX) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)

#include <stddef.h> // offsetof

namespace nn { namespace codec { namespace dsp {

using ArgumentType = uint32_t;

const size_t SharedMemorySize = 4096;   // 1 small page.
const size_t OneCacheLineExpected = 64; // in byte, conformed to the smaller size.
const size_t ArgumentCount = OneCacheLineExpected / sizeof(ArgumentType);
const size_t FreeBufferSize = SharedMemorySize - ArgumentCount * sizeof(ArgumentType) * 2;

typedef struct _SharedMemory
{
    // ToDo:
    // パフォーマンス計測のスコアや何やらを将来的に入れる予定。
    uint8_t buffer[FreeBufferSize];
#if defined(_NX_CODEC_DSP_) // DSP side
    ArgumentType from[ArgumentCount];
    ArgumentType to[ArgumentCount];
#else // CPU side
    ArgumentType to[ArgumentCount];
    ArgumentType from[ArgumentCount];
#endif

} SharedMemory;

#if defined(_NX_CODEC_DSP_)
#define NN_STATIC_ASSERT(cond) static_assert(cond, "Unexpected sizeof(nn::codec::dsp::SharedMemory)")
#endif

NN_STATIC_ASSERT(sizeof(SharedMemory) == SharedMemorySize);
NN_STATIC_ASSERT(offsetof(SharedMemory, from) % OneCacheLineExpected == 0);
NN_STATIC_ASSERT(offsetof(SharedMemory, to) % OneCacheLineExpected == 0);

}}}  // namespace nn::codec::dsp

#endif // defined(NN_BUILD_CONFIG_HARDWARE_NX) || defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2)
