﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

#include <nn/nn_Macro.h>
#include <nn/dd.h>

namespace nn {
namespace codec {
namespace detail {

// デバイスアドレス (SMMU) と仮想アドレスとを結びつけるためのクラス
class DeviceBuffer
{
public:
    DeviceBuffer() NN_NOEXCEPT
        : m_VirtualAddress(nullptr)
        , m_DeviceAddress(0)
        , m_Size(0)
    {}

    ~DeviceBuffer() NN_NOEXCEPT {} ;

    operator void*() const NN_NOEXCEPT
    {
        return m_VirtualAddress;
    }
    operator const void*() const NN_NOEXCEPT
    {
        return m_VirtualAddress;
    }
    NN_IMPLICIT operator uintptr_t() const NN_NOEXCEPT
    {
        return m_DeviceAddress;
    }

    // Setters
    inline void SetVirtualAddress(void* virtualAddress) NN_NOEXCEPT { m_VirtualAddress = virtualAddress; }
    inline void SetDeviceAddress(nn::dd::DeviceVirtualAddress deviceAddress) NN_NOEXCEPT { m_DeviceAddress = deviceAddress; }
    inline void SetSize(size_t size) NN_NOEXCEPT { m_Size = size; }
    inline void SetParameters(void* virtualAddress, nn::dd::DeviceVirtualAddress deviceAddress, size_t size) NN_NOEXCEPT
    {
        SetVirtualAddress(virtualAddress);
        SetDeviceAddress(deviceAddress);
        SetSize(size);
    }

    // Getters
    inline void* GetVirtualAddress() const NN_NOEXCEPT { return m_VirtualAddress; }
    inline nn::dd::DeviceVirtualAddress GetDeviceAddress() const NN_NOEXCEPT { return m_DeviceAddress; }
    inline size_t GetSize() const NN_NOEXCEPT { return m_Size; }
    inline bool IsAvailable() const NN_NOEXCEPT
    {
        return ( m_Size != 0 ) && ( m_DeviceAddress != 0 ) && ( m_VirtualAddress != nullptr );
    }

private:
    void* m_VirtualAddress;
    nn::dd::DeviceVirtualAddress m_DeviceAddress;
    size_t m_Size;
};

}}}  // nn::codec::detail
