﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/impl/sf_StaticOneAllocator.h>

#include "codec_HardwareOpusDecoderManagerImpl.h"

namespace nn { namespace codec {

// 機能へのアクセスは共有ポインタを利用します。
// 共有ポインタを返却する関数を作成し、サービス利用者はその関数で得られた共有ポインタを利用して、機能にアクセスします。
nn::sf::SharedPointer<detail::IHardwareOpusDecoderManager> CreateHardwareOpusDecoderManagerByDfc() NN_NOEXCEPT
{
    // CreateSharedEmplaced で Impl 側を紐付けた SharedPointer を返します。
    // Manager は 1つだけ存在する状態にしたいので、StaticOneAllocationPolicy でアロケートします。
    // 現在は impl の StaticOneAllocationPolicy を使ってしまっています。
    typedef nn::sf::ObjectFactory<nn::sf::impl::StaticOneAllocationPolicy>  Factory;
    return Factory::CreateSharedEmplaced<detail::IHardwareOpusDecoderManager, HardwareOpusDecoderManagerImpl>();
}

}}  // namespace nn::codec
