﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_SdkAssert.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_HipcServer.h>
#include <nn/sf/sf_ObjectFactory.h>
#include <nn/nn_Abort.h>

#include <nn/cec/cec_Server.h>

#include <cec_ICecManager.h>
#include <cec_ServerName.h>
#include <cec_ManagerImpl.h>
#include <cec_Manager.h>
#include <cec_Error.h>
#include "cec_ServerLog.h"

namespace nn { namespace cec { namespace server {

namespace {

class MyServerManager : public nn::sf::HipcSimpleAllInOneServerManager<30, 1>
{
private:
    virtual nn::sf::HipcServerSessionManagerCommonBase* GetHipcServerSessionManagerCommonBase(uint32_t tag) NN_NOEXCEPT;
};

std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_CecManagerStorage;
std::aligned_storage<sizeof(MyServerManager), NN_ALIGNOF(MyServerManager)>::type g_CecCancelStorage;
MyServerManager* g_pCecManager;
MyServerManager* g_pCecCancel;

nn::sf::HipcServerSessionManagerCommonBase* MyServerManager::GetHipcServerSessionManagerCommonBase(uint32_t tag) NN_NOEXCEPT
{
    switch (tag)
    {
        case 1: return g_pCecCancel;
        default: return this;
    }
}

nn::sf::UnmanagedServiceObject<ICecManager, CecManagerImpl> g_CecManager;

}

void InitializeCecServer() NN_NOEXCEPT
{
    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    NN_SDK_ASSERT(!g_pCecManager);
    detail::CecManagerInit(false);

    g_pCecManager = new (&g_CecManagerStorage) MyServerManager;

    g_pCecManager->RegisterObjectForPort(g_CecManager.GetShared(), maxSessionCount, CecServiceName);

    g_pCecManager->Start();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

void InitializeCecCancelServer() NN_NOEXCEPT
{
    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    NN_SDK_ASSERT(!g_pCecCancel);
    detail::CecManagerInit(false);

    g_pCecCancel  = new (&g_CecCancelStorage) MyServerManager;

    g_pCecCancel->Start();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

void LoopCecServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pCecManager);

    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    g_pCecManager->LoopAuto();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

void RequestStopCecServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pCecManager);

    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    g_pCecManager->RequestStop();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

void LoopCecCancelServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pCecCancel);

    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    g_pCecCancel->LoopAuto();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

void RequestStopCecCancelServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pCecCancel);

    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    g_pCecCancel->RequestStop();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

void FinalizeCecServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pCecManager);

    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    g_pCecManager->~MyServerManager();
    g_pCecManager = nullptr;
    detail::CecManagerShutdown();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

void FinalizeCecCancelServer() NN_NOEXCEPT
{
    NN_SDK_ASSERT(g_pCecCancel);

    NN_CEC_INFO("%s: entry\n", NN_CURRENT_FUNCTION_NAME);
    g_pCecCancel->~MyServerManager();
    g_pCecCancel = nullptr;
    detail::CecManagerShutdown();
    NN_CEC_INFO("%s: leave\n", NN_CURRENT_FUNCTION_NAME);
}

}}}
