﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

namespace nn { namespace cec { namespace detail {

typedef void (* ListenCallbackFunctionPointerType)(uint8_t, void*);

typedef struct {
    ListenCallbackFunctionPointerType   pCallbackFunction;
    void*                               pCallbackContext;
    uint8_t                             opcode;
} ReceiveListenerType;

int32_t CecReceiveBufferSetListener(uint8_t opcode, ListenCallbackFunctionPointerType pCallbackFunction, void* pCallbackContext) NN_NOEXCEPT;
int32_t CecReceiveBufferClearListener(uint8_t opcode, ListenCallbackFunctionPointerType pCallbackFunction) NN_NOEXCEPT;
int32_t CecReceiveBufferInit(uint8_t* pBuffer, uint32_t Length) NN_NOEXCEPT;
void    CecReceiveBufferShutdown() NN_NOEXCEPT;
void    CecReceiveBufferPurgeBuffer(bool sendSignalFlag) NN_NOEXCEPT;
int32_t CecRxBufferEnqueuePacket(uint8_t* pBuffer, uint32_t count) NN_NOEXCEPT;
int32_t CecRxBufferDequeuePacket(uint8_t* pBuffer, uint32_t* pCount, int32_t waitUs) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
