﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <stdint.h>

namespace nn { namespace cec { namespace detail {

const int FiniteStateMachineConstantMaxActionCount = 4;

typedef uint8_t FiniteStateMachineStateType;
typedef uint8_t FiniteStateMachineActionValueType;
typedef struct {
    FiniteStateMachineActionValueType   FsmActions[FiniteStateMachineConstantMaxActionCount];
} FiniteStateMachineActionType;
typedef uint8_t FiniteStateMachineInputType;
typedef void (* FiniteStateMachineActionHandlerFunctionPointerType)(FiniteStateMachineActionValueType, void*, void*);

typedef struct {
    FiniteStateMachineStateType                                 fsmState;
    FiniteStateMachineStateType                                 fsmNumState;
    FiniteStateMachineActionValueType                           fsmNumAction;
    FiniteStateMachineInputType                                 fsmNumInput;
    const FiniteStateMachineStateType*                          fsmStateMatrix;
    const FiniteStateMachineActionType*                         fsmActionMatrix;
    const FiniteStateMachineActionHandlerFunctionPointerType*   fsmActionHandlers;
    void*                                                       fsmClientContext;
} FiniteStateMachineType;

const FiniteStateMachineStateType       FsmParamNotAState    = 0xFF;
const FiniteStateMachineStateType       FsmParamDefaultState = 0;
const FiniteStateMachineActionValueType FsmParamNotAnAction  = 0xFF;
const FiniteStateMachineStateType       FsmParamMaxStates    = 0xFF;
const FiniteStateMachineActionValueType FsmParamMaxActions   = 0xFF;
const FiniteStateMachineInputType       FsmParamMaxInputs    = 0xFF;

void CecFiniteStateMachineInit(FiniteStateMachineType* pFsmState,
                               FiniteStateMachineStateType numStates,
                               FiniteStateMachineActionValueType numActions,
                               FiniteStateMachineInputType numInputs,
                               const FiniteStateMachineStateType* pStateMatrix,
                               const FiniteStateMachineActionType* pActionMatrix,
                               const FiniteStateMachineActionHandlerFunctionPointerType* pActionHandlers,
                               void* pContext) NN_NOEXCEPT;
void CecFiniteStateMachineStep(FiniteStateMachineType* pFsmState,
                               FiniteStateMachineInputType inputValue,
                               void* pExtra) NN_NOEXCEPT;

}
}   // namespace cec
}   // namespace nn
