﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief   UAC attach implementation
 */

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_Assert.h>

#include <nn/cduac/cduac_Spec.h>
#include <nn/cduac/cduac_Api.h>

namespace nn {
namespace cduac {


//////////////////////////////////////////////////////////////////////////////
Result Host::Initialize() NN_NOEXCEPT
{
    m_DeviceFilter.matchFlags       = nn::usb::DeviceFilterMatchFlags::DeviceFilterMatchFlags_InterfaceClass;
    m_DeviceFilter.bInterfaceClass  = nn::usb::UsbClass::UsbClass_Audio;

    return m_UsbHost.Initialize();
}


//////////////////////////////////////////////////////////////////////////////
Result Host::Finalize() NN_NOEXCEPT
{
    return m_UsbHost.Finalize();
}


//////////////////////////////////////////////////////////////////////////////
Result Host::CreateInterfaceAvailableEvent(nn::os::SystemEventType* pOutEvent) NN_NOEXCEPT
{
    return m_UsbHost.CreateInterfaceAvailableEvent(pOutEvent, nn::os::EventClearMode::EventClearMode_AutoClear, 0, &m_DeviceFilter);
}


//////////////////////////////////////////////////////////////////////////////
Result Host::DestroyInterfaceAvailableEvent(nn::os::SystemEventType* pInEvent) NN_NOEXCEPT
{
    return m_UsbHost.DestroyInterfaceAvailableEvent(pInEvent, 0);
}


//////////////////////////////////////////////////////////////////////////////
Result Host::QueryAvailableInterfaces(int32_t* pOutIfCount, nn::usb::InterfaceQueryOutput* pOutBuffer, size_t queryBufferSize) NN_NOEXCEPT
{
    return m_UsbHost.QueryAvailableInterfaces(pOutIfCount, pOutBuffer, queryBufferSize, &m_DeviceFilter);
}


//////////////////////////////////////////////////////////////////////////////
nn::usb::Host* Host::GetUsbHost() NN_NOEXCEPT
{
    return &m_UsbHost;
}


} // end of namespace cduac
} // end of namespace nn
