﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/
#include <mutex>

#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>

#include <nn/cdmsc.h>

#include "driver/cdmsc_Driver.h"

namespace {

    // The driver instance
    nn::cdmsc::driver::Driver s_Driver;

}

namespace nn {
namespace cdmsc {

Result
Initialize(nn::os::EventType *pDeviceAvailableEvent,
           AllocateFunction   alloc,
           DeallocateFunction dealloc)
{
    return s_Driver.Initialize(pDeviceAvailableEvent, alloc, dealloc);
}

Result
Finalize()
{
    return s_Driver.Finalize();
}

Result
Probe(nn::os::EventType *pDetachEvent, UnitProfile *pOutProfile)
{
    return s_Driver.Probe(pDetachEvent, pOutProfile);
}

Result
Read(void* pOutBuffer, UnitHandle unitHandle,
     uint64_t lba, uint32_t block)
{
    return s_Driver.Read(pOutBuffer, unitHandle, lba, block);
}

Result
Write(const void* pInBuffer, UnitHandle unitHandle,
      uint64_t lba, uint32_t block)
{
    return s_Driver.Write(pInBuffer, unitHandle, lba, block);
}

Result
Flush(UnitHandle handle, uint64_t lba, uint32_t block)
{
    return s_Driver.Flush(handle, lba, block);
}

}  // cdmsc
}  // nn

