﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "cdhidWin32Mouse_Private.h"

namespace nn {
namespace cdhid {
namespace win32 {

/////////////////////////////////////////////////////////////////////////////
//  public functions
//////////////////////////////////////////////////////////////////////////////
Result Win32MouseBuffer::Initialize(uint8_t* pBuffer, uint32_t entries, uint32_t entrySize) NN_NOEXCEPT
{
    m_pBuffer       = pBuffer;
    m_BufferEntries = entries;
    m_BufferSize    = entrySize;

    m_PutEntry      =
    m_GetEntry      =
    m_Entries       = 0;

    nn::os::InitializeSemaphore(&m_Semaphore, 0, m_BufferEntries);

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result Win32MouseBuffer::Finalize() NN_NOEXCEPT
{
    nn::os::FinalizeSemaphore(&m_Semaphore);

    return ResultSuccess();
}


/////////////////////////////////////////////////////////////////////////////
Result Win32MouseBuffer::Put(uint8_t* pSrc) NN_NOEXCEPT
{
    uint8_t *pDst = m_pBuffer + ((m_PutEntry++ % m_BufferEntries) * m_BufferSize);

    memcpy(pDst, pSrc, m_BufferSize);

    if (m_Entries < m_BufferEntries)
    {
        m_Entries++;
        nn::os::ReleaseSemaphore(&m_Semaphore);
    }
    else // overflow
    {
        m_GetEntry++;
    }

    return ResultSuccess();
}


//////////////////////////////////////////////////////////////////////////////
Result Win32MouseBuffer::Get(uint8_t* pDst, uint32_t* pBytesReceived) NN_NOEXCEPT
{
    nn::os::AcquireSemaphore(&m_Semaphore);

    uint8_t *pSrc = m_pBuffer + ((m_GetEntry++ % m_BufferEntries) * m_BufferSize);

    memcpy(pDst, pSrc, m_BufferSize);

    *pBytesReceived = m_BufferSize;

    m_Entries--;

    return ResultSuccess();
}

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
