﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

enum
{
    WIN32KEYBOARD_SERVER_STACK_SIZE    = 64 * 1024,
    WIN32KEYBOARD_SERVER_MAX_SESSIONS  = 5,
};

class Win32KeyboardServer : public nn::sf::HipcSimpleAllInOneServerManager<WIN32KEYBOARD_SERVER_MAX_SESSIONS, 1>
{
    NN_DISALLOW_COPY(Win32KeyboardServer);
    NN_DISALLOW_MOVE(Win32KeyboardServer);

public:

    Win32KeyboardServer() NN_NOEXCEPT{};
    ~Win32KeyboardServer() NN_NOEXCEPT{};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

private:

    Win32KeyboardInterface                  m_Win32KeyboardInterface;

    // Heap
    std::aligned_storage<64 * 1024>::type   m_SfHeapBuffer;
    nn::sf::ExpHeapAllocator                m_SfAllocator;
    nn::lmem::HeapHandle                    m_HeapHandle;

    // Thread
    NN_ALIGNAS(4096) uint8_t                m_ThreadStack[WIN32KEYBOARD_SERVER_STACK_SIZE];
    nn::os::ThreadType                      m_Thread;

    virtual nn::Result OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT;
    static void SessionThread(void *arg) NN_NOEXCEPT;
};

} // end of namespace win32
} // end of namespace cdhid
} // end of namespace nn
