﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace win32 {

enum
{
    WIN32_HID_SERVER_STACK_SIZE     = 16 * 1024,
    WIN32_HID_SERVER_MAX_SESSIONS   = (16 * 4) + 1,
};


class Win32HidServer : public nn::sf::HipcSimpleAllInOneServerManager<WIN32_HID_SERVER_MAX_SESSIONS, 1>
{

    NN_DISALLOW_COPY(Win32HidServer);
    NN_DISALLOW_MOVE(Win32HidServer);

public:

    Win32HidServer() NN_NOEXCEPT {};
    ~Win32HidServer() NN_NOEXCEPT {};

    Result Initialize() NN_NOEXCEPT;
    Result Finalize() NN_NOEXCEPT;

private:

    Win32HidEnum                            m_Win32HidEnum;

    // Heap
    std::aligned_storage<64 * 1024>::type   m_SfHeapBuffer;
    nn::sf::ExpHeapAllocator                m_SfAllocator;
    nn::lmem::HeapHandle                    m_HeapHandle;

    nn::os::ThreadType                      m_Thread;
    NN_ALIGNAS(4096) uint8_t                m_ThreadStack[WIN32_HID_SERVER_STACK_SIZE];

    virtual nn::Result OnNeedsToAccept(int portIndex, PortObjectImpl* pPort) NN_NOEXCEPT;
    static void SessionThread(void *arg) NN_NOEXCEPT;
};


}   // namespace win32
}   // namespace cdhid
}   // namespace nn
