﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

namespace nn {
namespace cdhid {
namespace usb {

class ServerSession : public nn::sf::ISharedObject
{

public:

    NN_IMPLICIT  ServerSession(UsbHidEnum *pUsbHidEnum, nn::sf::ExpHeapAllocator *pAllocator) NN_NOEXCEPT;
    NN_IMPLICIT ~ServerSession() NN_NOEXCEPT;

    Result AcquireDevice(uint32_t deviceHandle) NN_NOEXCEPT;
    Result ReleaseDevice(uint32_t deviceHandle) NN_NOEXCEPT;
    Result GetCtrlSession(uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::ICtrlSession>> outCtrlSession) NN_NOEXCEPT;
    Result GetReadSession(uint32_t deviceHandle, nn::sf::Out<nn::sf::SharedPointer<nn::ahid::IReadSession>> outReadSession) NN_NOEXCEPT;

private:

    uint32_t                    m_DeviceHandle;
    UsbHidEnum*                 m_pUsbHidEnum;
    UsbHidInterface*            m_pUsbHidInterface;
    nn::sf::ExpHeapAllocator*   m_pAllocator;
};

} // end of namespace usb
} // end of namespace cdhid
} // end of namespace nn
