﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_Abort.h>

#include <nn/os.h>
#include <nn/os/os_MemoryFence.h>
#include <nn/os/os_SdkThreadCommon.h>
#include <nn/os/os_SystemEvent.h>
#include <nn/nn_SystemThreadDefinition.h>

#include <nn/cdacm/cdacm_Result.h>
#include <nn/cdacm/cdacm_Types.h>

#include <nn/usb/usb_Host.h>

#include "../detail/cdacm_Log.h"
#include "../detail/cdacm_Utils.h"

const uint8_t NumberOfSupportedUarts = 2;
const uint8_t DeviceCountMax = 2;

enum UartVendorIndex
{
    UartVendorIndex_Ftdi = 0,
    UartVendorIndex_Prolific,
    UartVendorIndex_Max
};

enum FieldIndex
{
    FieldIndex_Vid = 0,
    FieldIndex_Pid,
    FieldIndex_Max
};

enum DeviceState
{
    DeviceState_Uninitialized = 0,
    DeviceState_Initialized
};

const uint16_t SupportedUarts[NumberOfSupportedUarts][FieldIndex_Max] =
{
    { 0x0403, 0x6001 },
    { 0x067B, 0x2303 }
};
