﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

// nn.TimeSpanType を使えるようにする
namespace nn {
    [CppRefPath(@"<nn/nn_TimeSpan.h>")]
    [ExternalStruct(8, 8)]
    public struct TimeSpanType
    {
    }
}

namespace nn.bpc
{
    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/bpc/bpc_PowerButtonTypes.h>")]
    public struct SleepButtonState
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/bpc/bpc_BoardPowerControlTypes.h>")]
    public struct BoardPowerControlEventTarget
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/bpc/bpc_PowerButtonTypes.h>")]
    public struct EventTarget
    {
    }

    [ExternalStruct(4, 4)]
    [CppRefPath(@"<nn/bpc/bpc_WakeupConfigTypes.h>")]
    public struct WakeupTimerType
    {
    }

    [CppRefPath("<nn/bpc/bpc_IBoardPowerControlManager.sfdl.h>")]
    interface IBoardPowerControlManager : IServiceObject
    {
        [MethodId(0)]
        Result ShutdownSystem();

        [MethodId(1)]
        Result RebootSystem();

        [MethodId(2)]
        Result GetWakeupReason(Out<uint32_t> pOutWakeupReason);

        [MethodId(3)]
        Result GetShutdownReason(Out<uint32_t> pOutShutdownReason);

        [MethodId(4)]
        Result GetAcOk(Out<bool> pOutAcOk);

        [MethodId(5)]
        Result GetPowerEvent(Out<NativeHandle> pOutHandle, BoardPowerControlEventTarget target);

        [MethodId(6)]
        Result GetSleepButtonState(Out<SleepButtonState> pOutState);

        [MethodId(7)]
        Result GetPowerButtonEvent(Out<NativeHandle> pOutHandle, EventTarget target);

        [MethodId(8)] // DEPRECATED
        Result CreateWakeupTimer(Out<int> outTimerId, nn.TimeSpanType interval);

        [MethodId(11)]
        Result CreateWakeupTimerEx(Out<int> outTimerId, nn.TimeSpanType interval, WakeupTimerType type);

        [MethodId(9)]
        Result CancelWakeupTimer(int timerId);

        // サーバサイドの機能へのアクセスを提供。テスト用
        [MethodId(10)]
        Result EnableWakeupTimerOnDevice(Out<bool> outIsEnabled, Out<int> outTimerId, Out<WakeupTimerType> outType);

        [MethodId(12)]
        Result GetLastEnabledWakeupTimerType(Out<WakeupTimerType> outType);

        // サーバサイドの機能へのアクセスを提供。テスト用
        [MethodId(13)]
        Result CleanAllWakeupTimers(WakeupTimerType type);
    }

    [CppRefPath("<nn/bpc/bpc_IRtcManager.sfdl.h>")]
    interface IRtcManager : IServiceObject
    {
        [MethodId(0)]
        Result GetRtcTime(Out<int64_t> outRtcTimeInSeconds);

        [MethodId(1)]
        Result SetRtcTime(int64_t rtcTimeInSeconds);

        [MethodId(2)]
        Result GetRtcResetDetected(Out<bool> pOutResetDetected);

        [MethodId(3)]
        Result ClearRtcResetDetected();

        [MethodId(4)]
        Result SetUpRtcResetOnShutdown();
    }
}
