﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/os.h>
#include <nn/os/os_Mutex.h>
#include <nn/bpc/bpc_ShimInternal.h>
#include <nn/bpc/bpc_BoardPowerControl.h>
#include <nn/bpc/bpc_PowerButton.h>

namespace nn { namespace bpc {

void InitializePowerButton() NN_NOEXCEPT
{
    InitializeBoardPowerControl();
}

void FinalizePowerButton() NN_NOEXCEPT
{
    FinalizeBoardPowerControl();
}

nn::Result GetSleepButtonState(SleepButtonState* pOutState) NN_NOEXCEPT
{
    NN_SDK_ASSERT(pOutState);

    auto pManager = GetInternalBoardPowerControlManager();
    NN_SDK_ASSERT_NOT_NULL(pManager);

    NN_RESULT_DO(pManager->GetSleepButtonState(pOutState));

    NN_RESULT_SUCCESS;
}

nn::Result GetPowerEvent(nn::os::SystemEventType* pOutEvent, EventTarget target) NN_NOEXCEPT
{
    NN_SDK_ASSERT(pOutEvent);

    auto pManager = GetInternalBoardPowerControlManager();
    NN_SDK_ASSERT_NOT_NULL(pManager);

    nn::sf::NativeHandle sfHandle;

    NN_RESULT_DO(pManager->GetPowerButtonEvent(&sfHandle, target));

    nn::os::AttachReadableHandleToSystemEvent(pOutEvent, sfHandle.GetOsHandle(), sfHandle.IsManaged(), nn::os::EventClearMode_ManualClear);

    sfHandle.Detach();

    NN_RESULT_SUCCESS;
}

}} // namepsace nn::bpc
