﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using nn;
using nn.sf;
using std;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;


namespace nn.bgtc
{
    [ExternalStruct(4, 4)]
    [Pre(@"static_cast<OperationMode>(_)")]
    [CppRefPath("<nn/bgtc/bgtc_Types.h>")]
    public struct OperationMode
    {
    }

    [CppRefPath(@"<nn/bgtc/detail/bgtc_ITaskService.sfdl.h>")]
    public interface ITaskService : IServiceObject
    {
        [MethodId(1)]
        Result NotifyTaskStarting();
        [MethodId(2)]
        Result NotifyTaskFinished();

        [MethodId(3)]
        Result GetTriggerEvent(nn.sf.Out<NativeHandle> outHandle);

        [MethodId(5)]
        Result NotifyClientName(nn.sf.InArray<char_t> name);

        [MethodId(11)]
        Result ScheduleTask(int32_t intervalSeconds);
        [MethodId(12)]
        Result GetScheduledTaskInterval(nn.sf.Out<std.int32_t> outSeconds);
        [MethodId(13)]
        Result UnscheduleTask();
        [MethodId(14)]
        Result GetScheduleEvent(nn.sf.Out<NativeHandle> outHandle);
        [MethodId(15)]
        Result SchedulePeriodicTask(int32_t intervalSecondsFirst, int32_t intervalSecondsPeriodic);

        [MethodId(4)]
        Result IsInHalfAwake(nn.sf.Out<bool> bResult);
        [MethodId(6)]
        Result IsInFullAwake(nn.sf.Out<bool> bResult);
        [MethodId(101)]
        Result GetOperationMode(nn.sf.Out<OperationMode> outOperationMode);
        [MethodId(102)]
        Result WillDisconnectNetworkWhenEnteringSleep(nn.sf.Out<bool> bResult);
        [MethodId(103)]
        Result WillStayHalfAwakeInsteadSleep(nn.sf.Out<bool> bResult);
    }
}
