﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn{ namespace bgtc{

class ClientBroker;
class IpcServerManager;
class CompositeEventHandlerThread;

class Instance
{
    NN_DISALLOW_COPY(Instance);
    NN_DISALLOW_MOVE(Instance);

private:
    ClientBroker& m_ClientBroker;
    IpcServerManager& m_IpcServerManager;
    CompositeEventHandlerThread & m_CompositeEventHandlerThread;

public:
    Instance();
    void Initialize();
    void Finalize();

    IpcServerManager& GetIpcServerManager()
    {
        return m_IpcServerManager;
    }

    ClientBroker& GetClientBroker()
    {
        return m_ClientBroker;
    }

    CompositeEventHandlerThread& GetCompositeEventHandlerThread()
    {
        return m_CompositeEventHandlerThread;
    }
};

extern Instance& g_Instance;

}}


