﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/psc.h>
#include <nn/os.h>
#include <nn/nn_TimeSpan.h>
#include <nn/bgtc/bgtc_Types.h>
#include <nn/bgsu/bgsu_PowerStateEventHandler.h>
#include <nn/bgsu/bgsu_ThreadTemplate.h>
#include <nn/bgsu/bgsu_MultiClientSystemEvent.h>

#include "bgtc_Common.h"
#include "bgtc_BackgroundStateEventHandler.h"
#include "bgtc_BatterySaver.h"


namespace nn{ namespace bgtc{

class CompositeEventHandlerThread : public bgsu::PowerStateEventHandler,
                                    public BackgroundStateEventHandler,
                                    public bgsu::ThreadTemplate<CompositeEventHandlerThread>
{
    typedef ThreadTemplate<CompositeEventHandlerThread> ThreadBase;

public:
    CompositeEventHandlerThread();
    virtual ~CompositeEventHandlerThread();

    Result Initialize();
    void Finalize();

    void TriggerEvent(EventCode eventCode);
    void AttachTaskRunnableEvent(bgsu::MultiClientSystemEvent::Node* pEventNode);
    void DetachTaskRunnableEvent(bgsu::MultiClientSystemEvent::Node* pEventNode);

    Result CheckTaskProcessable();
    bool IsHalfAwake();
    bool IsFullAwake();
    OperationMode JudgeOperationMode() const;

protected:
    virtual void OnReceivePowerStateEvent(psc::PmState stateLast, psc::PmState stateTo, psc::PmFlagSet flagset);

    virtual void ThreadBody();
    virtual void RequestExit();

private:
    bgsu::MultiClientSystemEvent  m_TaskRunnableEvent;
    BatterySaver                  m_BatterySaver;
    Time                          m_LastHalfAwakeTime;
    bool m_bIsInHalfAwake;
    bool m_bFullAwake;
};

}}
