﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/service/core/bcat_PushNotificationLogManager.h>
#include <nn/time.h>

namespace nn { namespace bcat { namespace detail { namespace service { namespace core {

PushNotificationLogManager::PushNotificationLogManager() NN_NOEXCEPT :
    m_Mutex(true),
    m_Count(0)
{
}

void PushNotificationLogManager::Notify(const TopicId& topicId) NN_NOEXCEPT
{
    nn::ApplicationId appId;

    if (!ParameterConverter::Convert(&appId, topicId) || appId == nn::ApplicationId::GetInvalidId())
    {
        return;
    }

    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    nn::time::PosixTime currentTime;

    if (nn::time::StandardNetworkSystemClock::GetCurrentTime(&currentTime).IsFailure())
    {
        currentTime.value = 0;
    }

    if (m_Count == PushNotificationLogCountMax)
    {
        m_Count--;
    }
    if (m_Count > 0)
    {
        std::memmove(&m_Logs[1], &m_Logs[0], sizeof (PushNotificationLog) * m_Count);
    }

    m_Logs[0].appId = appId;
    m_Logs[0].receivedTime = currentTime;
    m_Count++;
}

void PushNotificationLogManager::GetList(int* outCount, PushNotificationLog* outLogs, int count) const NN_NOEXCEPT
{
    NN_SDK_REQUIRES_NOT_NULL(outCount);
    NN_SDK_REQUIRES_NOT_NULL(outLogs);
    NN_SDK_REQUIRES_GREATER(count, 0);

    std::lock_guard<decltype (m_Mutex)> lock(m_Mutex);

    int actualCount = 0;

    for (int i = 0; i < m_Count; i++)
    {
        if (count-- == 0)
        {
            break;
        }

        outLogs[actualCount++] = m_Logs[i];
    }

    *outCount = actualCount;
}

}}}}}
