﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/bcat/detail/bcat_TypesDetail.h>
#include <nn/nn_SdkAssert.h>

namespace nn { namespace bcat { namespace detail {

void DeliveryCacheProgressImpl::Clear() NN_NOEXCEPT
{
    status = DeliveryCacheProgressStatusImpl_None;
    result = 0;

    std::memset(&dirName, 0, sizeof (dirName));
    std::memset(&fileName, 0, sizeof (fileName));

    currentDownloaded = 0;
    currentTotal = 0;
    wholeDownloaded = 0;
    wholeTotal = 0;

    std::memset(reserved, 0, sizeof (reserved));
}

void DeliveryCacheProgressImpl::NotifyStartConnect() NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(status, DeliveryCacheProgressStatusImpl_None);

    status = DeliveryCacheProgressStatusImpl_Connect;
}

void DeliveryCacheProgressImpl::NotifyStartProcessList() NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(status, DeliveryCacheProgressStatusImpl_Connect);

    status = DeliveryCacheProgressStatusImpl_ProcessList;
}

void DeliveryCacheProgressImpl::SetWholeDownloadSize(int64_t wholeTotal_) NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(status, DeliveryCacheProgressStatusImpl_ProcessList);

    wholeTotal = wholeTotal_;
}

void DeliveryCacheProgressImpl::SetDownloadProgress(int64_t downloaded, const DirectoryName& dirName_) NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(status, DeliveryCacheProgressStatusImpl_ProcessList);

    wholeDownloaded = downloaded;
    dirName = dirName_;
}

void DeliveryCacheProgressImpl::NotifyStartDownloadFile(const DirectoryName& dirName_, const FileName& fileName_, int64_t fileSize) NN_NOEXCEPT
{
    NN_SDK_ASSERT(status == DeliveryCacheProgressStatusImpl_ProcessList ||
        status == DeliveryCacheProgressStatusImpl_Download ||
        status == DeliveryCacheProgressStatusImpl_Commit);

    // 前回のダウンロード分を計上する。
    wholeDownloaded += currentDownloaded;

    status = DeliveryCacheProgressStatusImpl_Download;
    dirName = dirName_;
    fileName = fileName_;
    currentDownloaded = 0;
    currentTotal = fileSize;
}

bool DeliveryCacheProgressImpl::UpdateDownloadFileProgress(int64_t downloaded) NN_NOEXCEPT
{
    NN_SDK_ASSERT_EQUAL(status, DeliveryCacheProgressStatusImpl_Download);

    if (currentDownloaded < downloaded)
    {
        currentDownloaded = downloaded;
        return true;
    }

    return false;
}

void DeliveryCacheProgressImpl::NotifyStartCommitDirectory(const DirectoryName& dirName_) NN_NOEXCEPT
{
    NN_SDK_ASSERT(status == DeliveryCacheProgressStatusImpl_None ||
        status == DeliveryCacheProgressStatusImpl_ProcessList ||
        status == DeliveryCacheProgressStatusImpl_Download ||
        status == DeliveryCacheProgressStatusImpl_Commit);

    // 最後のダウンロード分を計上する。
    wholeDownloaded += currentDownloaded;

    status = DeliveryCacheProgressStatusImpl_Commit;
    dirName = dirName_;
    fileName.value[0] = '\0';
    currentDownloaded = 0;
    currentTotal = 0;
}

void DeliveryCacheProgressImpl::NotifyDone(nn::Result result_) NN_NOEXCEPT
{
    status = DeliveryCacheProgressStatusImpl_Done;

    std::memcpy(&result, &result_, sizeof (result));
}

}}}
