﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/sf/sf_ObjectFactory.h>
#include <nn/sf/sf_HipcClientProxyByName.h>
#include <nn/sf/sf_ExpHeapAllocator.h>

#include "audio_CreateAudioInManager.h"
#include "audio_ServiceName.h"

#include "../server/audio_AudioInManagerImpl.h"
#include "../server/audio_AudioInManagerForAppletImpl.h"
#include "../server/audio_AudioInManagerForDebuggerImpl.h"

namespace nn {
namespace audio {

nn::sf::UnmanagedServiceObject<detail::IAudioInManager, server::AudioInManagerImpl> g_AudioInManager;
nn::sf::UnmanagedServiceObject<detail::IAudioInManagerForDebugger, server::AudioInManagerForDebuggerImpl> g_AudioInManagerForDebugger;
nn::sf::UnmanagedServiceObject<detail::IAudioInManagerForApplet, server::AudioInManagerForAppletImpl> g_AudioInManagerForApplet;

nn::sf::SharedPointer<detail::IAudioInManager> CreateAudioInManagerByDfc() NN_NOEXCEPT
{
    return g_AudioInManager.GetShared();
}

nn::sf::SharedPointer<detail::IAudioInManagerForApplet> CreateAudioInManagerForAppletByDfc() NN_NOEXCEPT
{
    return g_AudioInManagerForApplet.GetShared();
}

nn::sf::SharedPointer<detail::IAudioInManagerForDebugger> CreateAudioInManagerForDebuggerByDfc() NN_NOEXCEPT
{
    return g_AudioInManagerForDebugger.GetShared();
}

}  // namespace audio
}  // namespace nn
