﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <mutex>
#include <nn/nn_SdkAssert.h>
#include "audio_CreateAudioRendererManager.h"

namespace nn {
namespace audio {

namespace {

nn::sf::SharedPointer<detail::IAudioRendererManagerForDebugger> CreateAudioRendererManagerForDebugger() NN_NOEXCEPT
{
#if defined(NN_BUILD_CONFIG_OS_HORIZON)
    return CreateAudioRendererManagerForDebuggerByHipc();
#else
    return CreateAudioRendererManagerForDebuggerByDfc();
#endif
}

} // anonymous namespace

nn::Result RequestSuspendAudioRenderersForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT
{
    auto audioRendererManagerForDebugger = CreateAudioRendererManagerForDebugger();
    NN_RESULT_DO(audioRendererManagerForDebugger->RequestSuspend(id));

    NN_RESULT_SUCCESS;
}

nn::Result RequestResumeAudioRenderersForDebug(nn::applet::AppletResourceUserId id) NN_NOEXCEPT
{
    auto audioRendererManagerForDebugger = CreateAudioRendererManagerForDebugger();
    NN_RESULT_DO(audioRendererManagerForDebugger->RequestResume(id));

    NN_RESULT_SUCCESS;
}

}  // namespace audio
}  // namespace nn
