﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

// 以下は固定で using を推奨
using Nintendo;
using Nintendo.ServiceFramework;
using Nintendo.ServiceFramework.CppCode;
using nn;
using nn.sf;
using std;

namespace nn.audio.detail
{
    [CppRefPath(@"<nn/audio/detail/audio_IAudioDebugManager.h>")]
    interface IAudioDebugManager : IServiceObject
    {
        [MethodId(0)]
        Result StartDspProfiler(NativeHandle processHandle, uint64_t bufferPtr, uint32_t bufferSize);

        [MethodId(1)]
        Result StopDspProfiler();

        [MethodId(2)]
        Result StartCpuProfiler();

        [MethodId(3)]
        Result StopCpuProfiler();
    }
}

