﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <windows.h>

namespace nn {
namespace audio {
namespace detail {

class ScopedHandle
{
public:
    NN_IMPLICIT ScopedHandle(HANDLE handle)
        : m_Handle(handle)
        , m_IsValid(true)
    {
    }
    ~ScopedHandle()
    {
        if (m_IsValid)
        {
            CloseHandle(m_Handle);
        }
    }
    NN_EXPLICIT_OPERATOR HANDLE() const
    {
        return m_Handle;
    }
    HANDLE Release()
    {
        auto ret(m_Handle);
        m_Handle = 0;
        m_IsValid = false;
        return ret;
    }
private:
    HANDLE m_Handle;
    bool m_IsValid;
};

}  // namespace detail
}  // namespace audio
}  // namespace nn
