﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>
#include <nn/nn_SdkAssert.h>

#include <clocale>
#pragma warning( push )
#pragma warning ( disable : 4668 )
#include <mmdeviceapi.h>
#include <audioclient.h>
#pragma warning( pop )
#include <Functiondiscoverykeys_devpkey.h>

namespace nn { namespace audio { namespace detail {

void GetDeviceName(IMMDevice* pDevice, char* name, size_t length) NN_NOEXCEPT
{
    IPropertyStore* pPropertyStore;
    PROPVARIANT varName;
    pDevice->OpenPropertyStore(STGM_READ, &pPropertyStore);
    PropVariantInit(&varName);
    pPropertyStore->GetValue(PKEY_Device_FriendlyName, &varName);

    int ret = WideCharToMultiByte(CP_UTF8, 0, varName.pwszVal, -1, name, static_cast<int32_t>(length), NULL, NULL);
    NN_SDK_ASSERT(ret > 0);
    NN_UNUSED(ret);
}

}}}  // namespace nn::audio::detail
