﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/Result/result_HandlingUtility.h>
#include "audio_AudioUnimplementedDriver.h"

namespace nn {
namespace audio {
namespace detail {

AudioUnimplementedDriver::AudioUnimplementedDriver() NN_NOEXCEPT
{
}

AudioUnimplementedDriver::~AudioUnimplementedDriver() NN_NOEXCEPT
{
}

Result AudioUnimplementedDriver::Open(server::SessionType sessionType, AppletVolumeManager::SessionType avmType, const char* name, server::SessionFormat& format, int sessionId, nn::dd::ProcessHandle processHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT
{
    NN_UNUSED(sessionType);
    NN_UNUSED(avmType);
    NN_UNUSED(name);
    NN_UNUSED(format);
    NN_UNUSED(sessionId);
    NN_UNUSED(processHandle);
    NN_UNUSED(aruid);

    NN_RESULT_THROW(ResultNotImplemented());
}
Result AudioUnimplementedDriver::Close() NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultNotImplemented());
}

Result AudioUnimplementedDriver::Start() NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultNotImplemented());
}

Result AudioUnimplementedDriver::Stop() NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultNotImplemented());
}

Result AudioUnimplementedDriver::Sleep() NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultNotImplemented());
}

Result AudioUnimplementedDriver::Wake() NN_NOEXCEPT
{
    NN_RESULT_THROW(ResultNotImplemented());
}

uint64_t AudioUnimplementedDriver::GetSamplesProcessed() const NN_NOEXCEPT
{
    return 0;
}

void* AudioUnimplementedDriver::MapBuffer(server::SessionBuffer& buffer, nn::dd::ProcessHandle processHandle) NN_NOEXCEPT
{
    NN_UNUSED(buffer);
    NN_UNUSED(processHandle);
    return nullptr;
}

void* AudioUnimplementedDriver::MapBuffer(server::SessionBuffer& buffer, nn::sf::NativeHandle&& bufferHandle) NN_NOEXCEPT
{
    //no-op: This is for mapping user buffer to audio process
    NN_UNUSED(buffer);
    NN_UNUSED(bufferHandle);
    return nullptr;
}

bool AudioUnimplementedDriver::UnmapBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT
{
    NN_UNUSED(buffer);
    return false;
}

bool AudioUnimplementedDriver::TryCompleteBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT
{
    NN_UNUSED(buffer);
    return false;
}

Result AudioUnimplementedDriver::AppendBuffer(const server::SessionBuffer& buffer) NN_NOEXCEPT
{
    NN_UNUSED(buffer);
    NN_RESULT_THROW(ResultNotImplemented());
}

void* AudioUnimplementedDriver::GetBufferAddress() const NN_NOEXCEPT
{
    return nullptr;
}

Result AudioUnimplementedDriver::SetDeviceGain(float gain) NN_NOEXCEPT
{
    NN_UNUSED(gain);
    NN_RESULT_THROW(ResultNotImplemented());
}

float AudioUnimplementedDriver::GetDeviceGain() const NN_NOEXCEPT
{
    return 1.0f;
}

}  // namespace detail
}  // namespace audio
}  // namespace nn


