﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "../audio_MixManager.h"
#include "../audio_AddrTypes.h"
#include "../common/audio_SortLogic.h"
#include "../common/audio_Util.h"
#include "audio_ServiceBehaviorInfo.h"
#include "audio_ServiceSplitterInfo.h"

namespace nn { namespace audio { namespace server {

class EffectContext;

struct NN_AUDIO_INFOTYPE_FILED_ALIGN MixInfo final
{
    // SubMix/FinalMix 共通で使用する変数
    float volume;
    int32_t sampleRate;
    int32_t bufferCount;
    bool isInUse;
    int8_t _padding[3];

    ::nn::audio::MixId mixId;
    ::nn::audio::NodeId nodeId;
    int32_t bufferOffset;
    int32_t distanceFromFinalMix;

    static const int32_t InvalidDistanceFromFinalMix;

    CpuAddr effectProcessingOrder;
    int32_t effectProcessingOrderCountMax;

    // SubMix でのみ使用される変数
    ::nn::audio::MixId destinationMixId;
    float mixVolume[MixBufferCountMax][MixBufferCountMax];
    common::SplitterInfoId splitterInfoId;
    bool longSizePreDelaySupported;
    int8_t reserved[11];

    static const ::nn::audio::MixId FinalMixId = 0;
    static const ::nn::audio::MixId SubMixIdFirst = FinalMixId + 1;

    MixInfo(int32_t* processingOrder, int32_t orderCountMax, const server::BehaviorInfo& behaviorInfo) NN_NOEXCEPT;
    void Update(
        common::EdgeMatrix& edges,
        const nn::audio::MixInfo& inMix,
        const EffectContext& effectContext,
        const SplitterContext& splitterContext,
        const server::BehaviorInfo& behaviorInfo) NN_NOEXCEPT;
    void ClearEffectProcessingOrder() NN_NOEXCEPT;
    bool HasAnyConnection() const NN_NOEXCEPT;

private:
    void CleanUp() NN_NOEXCEPT;
    void UpdateConnection(common::EdgeMatrix& edges, const nn::audio::MixInfo& inMix, const SplitterContext& splitterContext) NN_NOEXCEPT;
};
#if defined(NN_BUILD_CONFIG_SPEC_NX) && !defined(NN_BUILD_CONFIG_OS_WIN)
NN_AUDIO_INFOTYPE_CHECK(MixInfo, 2368);
#endif

// Data container & access0r for service side Mix related infos.
class MixContext
{
private:
    server::MixInfo** m_SortedInfos;
    server::MixInfo* m_Infos;
    int m_InfoCount;
    int32_t* m_EffectProcessingOrderBuffer;
    size_t m_EffectProcessingOrderBufferSize;


public:
    common::NodeStates m_NodeState;
    common::EdgeMatrix m_Edges;

private:
    void UpdateDistancesFromFinalMix() NN_NOEXCEPT;

public:
    MixContext() NN_NOEXCEPT;
    void Initialize(server::MixInfo** sorted, server::MixInfo* info, int infoCount,
        int32_t* effectProcessingOrderBuffer, size_t effectProcessingOrderBufferSize,
        void* nodeStateBuffer, size_t nodeStateBufferSize,
        void* edgeMatrixBuffer, size_t edgeMatrixBufferSize) NN_NOEXCEPT;
    server::MixInfo& GetSortedInfo(int index) const NN_NOEXCEPT;
    void SetSortedInfo(int index, server::MixInfo* pInfo) NN_NOEXCEPT;
    server::MixInfo& GetInfo(MixId id) const NN_NOEXCEPT;
    server::MixInfo& GetFinalMixInfo() const NN_NOEXCEPT;
    int GetCount() const NN_NOEXCEPT;

    bool TsortInfo(const SplitterContext& splitterContext) NN_NOEXCEPT;
    void SortInfo() NN_NOEXCEPT;
    void CalcMixBufferOffset() NN_NOEXCEPT;
};

}}}  // namespace nn::audio::server
