﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/nn_Common.h>

namespace nn { namespace audio {

    extern "C" uint32_t interpolating1Ch16TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t interpolating2Ch16TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t interpolating6Ch16TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t interpolating1Ch32TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t interpolating2Ch32TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t interpolating6Ch32TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t decimating1Ch16TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t decimating2Ch16TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t decimating6Ch16TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t decimating1Ch32TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t decimating2Ch32TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);
    extern "C" uint32_t decimating6Ch32TapFilter(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount);

double  computeAcutalOutputSampleRate(int inputSampleRate, int outputSampleRate) NN_NOEXCEPT;
uint32_t polyphaseResample(void* filter, const int16_t* input, int16_t* output, uint32_t inputSampleCount) NN_NOEXCEPT;
size_t requiredPolyphaseResamplerMemory(uint32_t numberOfChannels, uint32_t interpolationFactor, uint32_t decimationFactor, bool highQuality) NN_NOEXCEPT;
size_t  estimatePolyphaseResamplerOutputBufferSize(void* state, size_t inputBufferSize, bool applyPadding) NN_NOEXCEPT;
int estimatePolyphaseResamplerOutputSampleCount(void* state, int inputSampleCount, bool applyPadding) NN_NOEXCEPT;
void initializePolyphaseResampler(void* state, uint32_t interpolationFactor, uint32_t decimationFactor, uint32_t numberOfChannels, bool highQuality, float gain) NN_NOEXCEPT;

}}
