﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "audio_AudioOutClient.h"

namespace nn { namespace audio { namespace server {


Result AudioOutClient::Initialize(const char* name) NN_NOEXCEPT
{
    return m_Impl.Initialize(name);
}

Result AudioOutClient::Finalize() NN_NOEXCEPT
{
    return m_Impl.Finalize();
}

int AudioOutClient::GetSampleRate() const NN_NOEXCEPT
{
    return m_Impl.GetSampleRate();
}

int AudioOutClient::GetChannelCount() const NN_NOEXCEPT
{
    return m_Impl.GetChannelCount();
}

int AudioOutClient::GetBitsPerSample() const NN_NOEXCEPT
{
    return m_Impl.GetBitsPerSample();
}

void AudioOutClient::Wait() NN_NOEXCEPT
{
    return m_Impl.Wait();
}

void* AudioOutClient::AcquireBuffer(int sampleCount) NN_NOEXCEPT
{
    return m_Impl.AcquireBuffer(sampleCount);
}

void AudioOutClient::ReleaseBuffer(int sampleCount) NN_NOEXCEPT
{
    return m_Impl.ReleaseBuffer(sampleCount);
}

}}}  // namespace nn::audio::server
