﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/os/os_SystemEvent.h>
#include <nn/nn_TimeSpan.h>
#include <nn/util/util_BitFlagSet.h>
#include <nn/audioctrl/audioctrl_AudioControllerTypes.h>

#include "audio_AudioHardwareConfiguration.h"

// TODO: Change more proper namespace
namespace nn { namespace audio {

// For start up routines
void InitializeAudioHardware(bool hasCodecIc, bool hasHda) NN_NOEXCEPT;
void FinalizeAudioHardware() NN_NOEXCEPT;
void ShutdownAudioHardware() NN_NOEXCEPT;
void SleepAudioHardware() NN_NOEXCEPT;
void WakeAudioHardware() NN_NOEXCEPT;
void NotifyOutputDeviceEvent() NN_NOEXCEPT;
void NotifyOutputDeviceEvent(bool isHda, nn::TimeSpanType fadeOutTime, nn::TimeSpanType fadeInTime) NN_NOEXCEPT;
void NotifyHeadphoneOutSelect(bool isEnable) NN_NOEXCEPT;
void NotifyHeadphoneInEnabled(bool isEnable) NN_NOEXCEPT;
void SetOutputMasterVolume(float volume, uint32_t curveDurationInMicroseconds) NN_NOEXCEPT;
bool IsAnalogMicrophonePlugged() NN_NOEXCEPT;

// For audio hardware state dump
void DumpAudioHardwareState() NN_NOEXCEPT;

// For CodecController
nn::os::SystemEvent* RegisterJackEvent() NN_NOEXCEPT;
void UnregisterJackEvent() NN_NOEXCEPT;
void ClearJackEvent() NN_NOEXCEPT;
bool IsJackPlugged() NN_NOEXCEPT;
void SetSpeakerVolume(int32_t volume) NN_NOEXCEPT;
void SetHeadphoneVolume(int32_t volume) NN_NOEXCEPT;
void SetSpeakerMute(bool mute) NN_NOEXCEPT;
bool IsSpeakerMute() NN_NOEXCEPT;
bool IsCodecRequested() NN_NOEXCEPT;
void SetHeadphoneAmplifierGain(int32_t gain) NN_NOEXCEPT;
void SetUacOutputDeviceVolume(float volume) NN_NOEXCEPT;
}} // namespace nn::audio
