﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include <nn/nn_Macro.h>

namespace nn { namespace audio { namespace dsp { namespace detail {

int32_t ApplyDepopMix2(int32_t* output, int32_t startSample, int32_t factor, int sampleCount) NN_NOEXCEPT
{
    const int Q = 15;

    if (startSample > 0)
    {
        auto x1 = static_cast<int32_t>((static_cast<int64_t>(startSample) * factor) >> Q);
        auto x2 = static_cast<int32_t>((static_cast<int64_t>(x1)          * factor) >> Q);
        output[0] += x1;
        output[1] += x2;
        auto factor2 = factor * factor;
        const auto Q2 = Q * 2;
        for (int i = 2; i < sampleCount; i += 2)
        {
            x1 = static_cast<int32_t>((static_cast<int64_t>(x1) * factor2) >> Q2);
            x2 = static_cast<int32_t>((static_cast<int64_t>(x2) * factor2) >> Q2);
            output[i + 0] += x1;
            output[i + 1] += x2;
        }
        return x2;
    }
    else
    {
        startSample = -startSample;
        auto x1 = static_cast<int32_t>((static_cast<int64_t>(startSample) * factor) >> Q);
        auto x2 = static_cast<int32_t>((static_cast<int64_t>(x1)          * factor) >> Q);
        output[0] -= x1;
        output[1] -= x2;
        auto factor2 = factor * factor;
        const auto Q2 = Q * 2;
        for (int i = 2; i < sampleCount; i += 2)
        {
            x1 = static_cast<int32_t>((static_cast<int64_t>(x1) * factor2) >> Q2);
            x2 = static_cast<int32_t>((static_cast<int64_t>(x2) * factor2) >> Q2);
            output[i + 0] -= x1;
            output[i + 1] -= x2;
        }
        return -x2;
    }
}

}}}}  // namespace nn::audio::dsp::detail
