﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstdint>

#if defined(__ARM_NEON__) || defined(__ARM_NEON)
#include "detail/audio_Resample.neon.h"
#else  // defined(__ARM_NEON__) || defined(__ARM_NEON)
#include "detail/audio_Resample.generic.h"
#endif  // defined(__ARM_NEON__) || defined(__ARM_NEON)

namespace nn {
namespace audio {

void Resample(int32_t* output, const int32_t* input, int32_t pitch, int32_t* pFraction, int sampleCount)
{
    dsp::detail::ResampleImpl(output, input, pitch, pFraction, sampleCount);
}

}  // namespace audio
}  // namespace nn

