﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>

namespace nn { namespace audio { namespace dsp {

void ApplyMix(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyMix1(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyMix2(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyMix4(int32_t* output, const int32_t* input, int32_t gain, int sampleCount) NN_NOEXCEPT;
void ApplyMix(float* output, const float* input, float gain, int sampleCount) NN_NOEXCEPT;
void ApplyMix1(float* output, const float* input, float gain, int sampleCount) NN_NOEXCEPT;
void ApplyMix4(float* output, const float* input, float gain, int sampleCount) NN_NOEXCEPT;
int32_t ApplyMixRamp(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
int32_t ApplyMixRamp1(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
int32_t ApplyMixRamp2(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
int32_t ApplyMixRamp4(int32_t* output, const int32_t* input, int32_t gain, int32_t delta, int sampleCount) NN_NOEXCEPT;
float ApplyMixRamp(float* output, const float* input, float gain, float delta, int sampleCount) NN_NOEXCEPT;
float ApplyMixRamp1(float* output, const float* input, float gain, float delta, int sampleCount) NN_NOEXCEPT;
float ApplyMixRamp4(float* output, const float* input, float gain, float delta, int sampleCount) NN_NOEXCEPT;

}}}  // namespace nn::audio::dsp
