﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <limits>
#include "audio_DspCommon.h"
#include "audio_MailBoxImplByAdspMailBoxAdsp.h"

namespace nn { namespace audio { namespace dsp {

void MailBoxImplByAdspMailBoxAdsp::Initialize() NN_NOEXCEPT
{

}

void MailBoxImplByAdspMailBoxAdsp::Finalize() NN_NOEXCEPT
{

}

void MailBoxImplByAdspMailBoxAdsp::Open(int id, bool isServer) NN_NOEXCEPT
{
    NN_AUDIO_DSP_ASSERT(isServer == true);
    NN_AUDIO_DSP_ASSERT(id <= std::numeric_limits<int16_t>::max());
    int16_t mailBoxId = static_cast<int16_t>(id);

    auto result = mbx_open(&m_MailBox, &mailBoxId, NULL, NULL, NULL, NULL, NULL);
    NN_AUDIO_DSP_ASSERT(result == 0);

    result = mbx_attr(&m_MailBox, ADSP_MBX_OWNER_ONLY, false);
    NN_AUDIO_DSP_ASSERT(result == NO_ERROR);
}

void MailBoxImplByAdspMailBoxAdsp::Close() NN_NOEXCEPT
{
    auto result = mbx_close(&m_MailBox);
    NN_AUDIO_DSP_ASSERT(result == NO_ERROR);
}

void MailBoxImplByAdspMailBoxAdsp::Send(int32_t message) NN_NOEXCEPT
{
    for(;;)
    {
        const auto result = mbx_send_msg(&m_MailBox, message, 0, 0);
        if(result == NO_ERROR)
        {
            break;
        }

        mbx_clear_err_code(&m_MailBox);
        thread_sleep(1);
    }
}

int32_t MailBoxImplByAdspMailBoxAdsp::Recv() NN_NOEXCEPT
{
    int32_t message;
    const auto result = mbx_recv_msg(&m_MailBox, &message, true, INFINITE_TIME);
    NN_AUDIO_DSP_ASSERT(result == NO_ERROR);
    return message;
}

}}}  // namespace nn::audio::dsp

