﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "audio_MailBox.h"

namespace nn { namespace audio { namespace dsp {

void MailBox::Initialize() NN_NOEXCEPT
{
    MailBoxImpl::Initialize();
}

void MailBox::Finalize() NN_NOEXCEPT
{
    MailBoxImpl::Finalize();
}

void MailBox::Open(int id, bool isServer) NN_NOEXCEPT
{
    m_Impl.Open(id, isServer);
}

void MailBox::Close() NN_NOEXCEPT
{
    m_Impl.Close();
}

void MailBox::Send(int32_t message) NN_NOEXCEPT
{
    m_Impl.Send(message);
}

int32_t MailBox::Recv() NN_NOEXCEPT
{
    return m_Impl.Recv();
}

}}}  // namespace nn::audio::dsp
