﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>

#ifndef _NX_AUDIO_DSP_
#include "../server/audio_AudioOutClient.h"
#endif

#include "audio_Downsampler.h"

namespace nn { namespace audio {

struct Device
{
    static const int InputCountMax = 6;

#ifndef _NX_AUDIO_DSP_
    server::AudioOutClient _client;
#endif
    void* pCurrent;
    DownSamplerState state[InputCountMax];
    char name[256];
    uint32_t sessionId;
};

Result InitializeDevice(Device* p, uint32_t sessionId) NN_NOEXCEPT;
void FinalizeDevice(Device* p) NN_NOEXCEPT;
DownSamplerState* GetDeviceDownsampleState(Device* p) NN_NOEXCEPT;
int GetDeviceSampleRate(const Device* p) NN_NOEXCEPT;
int GetDeviceChannelCount(const Device* p) NN_NOEXCEPT;
void* GetDeviceBuffer(Device* p) NN_NOEXCEPT;

void InitializeDeviceManager() NN_NOEXCEPT;
void FinalizeDeviceManager() NN_NOEXCEPT;
Device* GetDevice(const char* name, uint32_t sessionId) NN_NOEXCEPT;

void WaitDevice(int sessionId, int sampleCount) NN_NOEXCEPT;
void BeginOutputToDevice(int sessionId, int sampleCount) NN_NOEXCEPT;
void EndOutputToDevice(int sessionId, int sampleCount) NN_NOEXCEPT;

bool IsRunning(int sessionId) NN_NOEXCEPT;
bool IsSuspended(int sessionId) NN_NOEXCEPT;
bool IsStopped(int sessionId) NN_NOEXCEPT;
void StartDevice(int sessionId) NN_NOEXCEPT;
void SuspendDevice(int sessionId) NN_NOEXCEPT;
void ResumeDevice(int sessionId) NN_NOEXCEPT;
void ResetDevice(int sessionId) NN_NOEXCEPT;

}}  // namespace nn::audio
