﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Common.h>

#if defined(__ARM_NEON__) || defined(__ARM_NEON)
#include "detail/audio_Depop.neon.h"
#else // defined(__ARM_NEON__) || defined(__ARM_NEON)
#include "detail/audio_Depop.generic.h"
#endif // defined(__ARM_NEON__) || defined(__ARM_NEON)


namespace nn { namespace audio { namespace dsp {

int32_t ApplyDepop(int32_t* output, int32_t startSample, int32_t factor, int sampleCount) NN_NOEXCEPT
{

    const int Q = 15;
    if (startSample > 0)
    {
        auto x = startSample;
        for (auto i = 0; i < sampleCount; ++i)
        {
            x = (static_cast<int64_t>(x) * factor) >> Q;
            output[i] = x;
        }
        return x;
    }
    else
    {
        auto x = -startSample;
        for (auto i = 0; i < sampleCount; ++i)
        {
            x = (static_cast<int64_t>(x) * factor) >> Q;
            output[i] = -x;
        }
        return -x;
    }
}

int32_t ApplyDepopMix1(int32_t* output, int32_t startSample, int32_t factor, int sampleCount) NN_NOEXCEPT
{
    const int Q = 15;
    if (startSample > 0)
    {
        auto x = startSample;
        for (auto i = 0; i < sampleCount; ++i)
        {
            x = (static_cast<int64_t>(x) * factor) >> Q;
            output[i] += x;
        }
        return x;
    }
    else
    {
        auto x = -startSample;
        for (auto i = 0; i < sampleCount; ++i)
        {
            x = (static_cast<int64_t>(x) * factor) >> Q;
            output[i] -= x;
        }
        return -x;
    }
}

int32_t ApplyDepopMix2(int32_t* output, int32_t startSample, int32_t factor, int sampleCount) NN_NOEXCEPT
{
    return detail::ApplyDepopMix2(output, startSample, factor, sampleCount);
}


int32_t ApplyDepopMix(int32_t* output, int32_t startSample, int32_t factor, int sampleCount) NN_NOEXCEPT
{
    if (sampleCount & 0x1)
    {
        return ApplyDepopMix1(output, startSample, factor, sampleCount);
    }
    else
    {
        return ApplyDepopMix2(output, startSample, factor, sampleCount);
    }
}

}}}  // namespace nn::audio::dsp
