﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <cstdint>
#include "../common/audio_CommonWaveBuffer.h"

namespace nn {
namespace audio {

void GetOpusData(int32_t* output, VoiceState* state, const common::WaveBuffer waveBuffer[], int32_t _pitch, int sourceSampleRate, int targetSampleRate, int sampleCount, bool isPlayedSampleCountResetAtLoopPoint) NN_NOEXCEPT;

struct DecodeFromWaveBuffersArgs
{
    SampleFormat format;
    int32_t* output;
    VoiceState* state;
    const common::WaveBuffer* waveBuffer;
    int32_t channel;
    int32_t channelCount;
    int32_t pitch;
    int sourceSampleRate;
    int targetSampleRate;
    int sampleCount;
    const int16_t* pCoef;
    bool isPlayedSampleCountResetAtLoopPoint;
    bool isPitchAndSrcSkipped;
};

void DecodeFromWaveBuffers(const DecodeFromWaveBuffersArgs& args) NN_NOEXCEPT;

}  // namespace audio
}  // namespace nn
