﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/TargetConfigs/build_Base.h>

#if ((defined(NN_BUILD_CONFIG_HARDWARE_JETSONTK2) || defined(NN_BUILD_CONFIG_HARDWARE_NX)) && !defined(NN_SDK_BUILD_LIBRARY)) \
    || defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_AUDIO_SYSTEM_PROCESS
#endif

#if !defined(NN_AUDIO_SYSTEM_PROCESS) || defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_AUDIO_ENABLE_CPU_RENDERER
#elif defined(NN_BUILD_CONFIG_SOC_TEGRA_X1) && defined(NN_AUDIO_SYSTEM_PROCESS)
#define NN_AUDIO_ENABLE_ADSP_RENDERER
#endif

#if defined(NN_AUDIO_ENABLE_CPU_RENDERER) && defined(NN_BUILD_CONFIG_ADDRESS_64)
#define NN_AUDIO_DSP_ADDR_SIZE 8 // NOLINT(readability/define)
#elif defined(_NX_AUDIO_DSP_) || defined(NN_AUDIO_ENABLE_ADSP_RENDERER) || (defined(NN_AUDIO_ENABLE_CPU_RENDERER) && defined(NN_BUILD_CONFIG_ADDRESS_32))
#define NN_AUDIO_DSP_ADDR_SIZE 4 // NOLINT(readability/define)
#else
#error Unsupported platform.
#endif

#if defined(NN_AUDIO_SYSTEM_PROCESS) && defined(NN_BUILD_CONFIG_OS_HORIZON)
#define NN_AUDIO_ENABLE_APPLET_VOLUME_MANAGER
#endif

#if defined(NN_AUDIO_SYSTEM_PROCESS)
#define NN_AUDIO_ENABLE_AUDIO_RENDER_SYSTEM_MANAGER
#endif

#if !defined(NN_BUILD_CONFIG_OS_WIN) && defined(NN_AUDIO_SYSTEM_PROCESS) && !defined(NN_AUDIO_FORCE_SKIP_INFOTYPE_CHECK)
#define NN_AUDIO_ENABLE_INFOTYPE_CHECK
#endif

#if defined(NN_BUILD_CONFIG_OS_WIN) || defined(_NX_AUDIO_DSP_)
#define NN_AUDIO_ENABLE_DEVICE_SINK
#endif

#if defined(NN_AUDIO_ENABLE_DEVICE_SINK) && defined(NN_BUILD_CONFIG_OS_WIN)
#define NN_AUDIO_ENABLE_DEVICE_SINK_DOWNSAMPLER
#endif

#if defined(__ARM_NEON) && __ARM_NEON == 1 && defined(__ARM_ARCH_ISA_A64) && __ARM_ARCH_ISA_A64 == 1
#define NN_AUDIO_ENABLE_AARCH64_NEON
#endif
