﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/nn_StaticAssert.h>
#include <nn/os/os_Mutex.h>
#include <nn/audio/audio_Common.h>
#include "common/audio_SinkParameters.h"
#include "audio_AddrTypes.h"

namespace nn {
namespace audio {

struct SinkInfo
{
    static const int InputCountMax = 6;

    common::SinkType _type;
    bool _isInUse;
    NodeId _nodeId;
    int8_t _reserved[8];

    union
    {
        common::CircularBufferParameter circularInParam;
        common::DeviceParameter deviceInParam;
    };

    union
    {
        common::CircularBufferStatus circularOutStatus;
    };

    SinkInfo() NN_NOEXCEPT;
    common::SinkType GetType() const NN_NOEXCEPT;
    size_t StoreInParameter(common::SinkInParameter& param) NN_NOEXCEPT;
    size_t StoreOutStatus(common::SinkOutStatus& outStatus) NN_NOEXCEPT;
    bool IsUsed() const NN_NOEXCEPT;
    void CleanUp() NN_NOEXCEPT;
};

class SinkManager
{
private:
    int32_t m_Count;
    int32_t m_FinalMixSampleCount;
    int32_t m_FinalMixSampleRate;
    SinkInfo* m_Infos;
    nn::os::Mutex m_Mutex;
public:
    SinkManager(int count, SinkInfo* pInfo, int32_t sampleCount, int32_t sampleRate) NN_NOEXCEPT;
    SinkInfo* Allocate(common::SinkType type) NN_NOEXCEPT;
    void Free(SinkInfo* p) NN_NOEXCEPT;

    int32_t GetSampleCount() const NN_NOEXCEPT;
    int32_t GetSampleRate() const NN_NOEXCEPT;
    bool IsValidSinkInfo(const SinkInfo* pInfo) const NN_NOEXCEPT;

    size_t UpdateSinkInParameter(common::SinkInParameter* pParameter) NN_NOEXCEPT;
    size_t UpdateSinkOutStatus(common::SinkOutStatus* pOutStatus) NN_NOEXCEPT;
};

}  // namespace audio
}  // namespace nn
